#!/bin/bash

# Set the total run time (in seconds) and interval time (in seconds)
TOTAL_TIME=300 # 5 minutes = 300 seconds
INTERVAL=30 # 30-second interval
COUNT=$((TOTAL_TIME / INTERVAL)) # Count the number of executions

echo "Start monitoring WiFi signal strength (once every $INTERVAL seconds, $COUNT times in total)..."
echo "----------------------------------------"

for ((i=1; i<=COUNT; i++))
do
echo "$i detection ($(date '+%Y-%m-%d %H:%M:%S')):"
iw dev wlan0 link | grep -i signal
echo "----------------------------------------"
sleep $INTERVAL
done

echo "Monitoring completed!"